document.addEventListener("DOMContentLoaded", async () => {
  const dwaUrlInput = document.getElementById("dwa-url");
  const apiKeyInput = document.getElementById("api-key");
  const reporterNameInput = document.getElementById("reporter-name");
  const reporterEmailInput = document.getElementById("reporter-email");
  const saveBtn = document.getElementById("save-btn");
  const status = document.getElementById("status");

  // Load existing settings
  const data = await chrome.storage.sync.get(["dwaUrl", "dwaApiKey", "reporterName", "reporterEmail"]);
  dwaUrlInput.value = data.dwaUrl || "";
  apiKeyInput.value = data.dwaApiKey || "";
  reporterNameInput.value = data.reporterName || "";
  reporterEmailInput.value = data.reporterEmail || "";

  saveBtn.addEventListener("click", async () => {
    const dwaUrl = dwaUrlInput.value.trim();
    const dwaApiKey = apiKeyInput.value.trim();
    const reporterName = reporterNameInput.value.trim();
    const reporterEmail = reporterEmailInput.value.trim();

    await chrome.storage.sync.set({ dwaUrl, dwaApiKey, reporterName, reporterEmail });

    status.className = "success";
    status.textContent = "Settings saved";
    status.style.display = "block";

    setTimeout(() => {
      status.style.display = "none";
    }, 2000);
  });
});
