# DWA Bug Reporter — Chrome Web Store Listing

## Short Description (132 chars max)

Capture region screenshots and submit bug reports directly to your self-hosted DWA Builder kanban board. Internal team tool.

## Detailed Description

DWA Bug Reporter lets your team capture and submit bug reports with region-select screenshots directly to your self-hosted DWA Builder kanban board — no copy-pasting URLs, no separate bug trackers, no context switching.

**How It Works**

1. Right-click on any web page and select "Report Bug to DWA Builder"
2. A crosshair overlay appears — drag to select the exact region you want to capture
3. The extension popup opens with your cropped screenshot. Pick a project, describe the bug, and hit Submit

Your bug report — complete with screenshot, description, and page URL — lands on your DWA Builder kanban board instantly.

**Features**

- Region-select screenshots: Capture exactly the area that shows the bug, not the whole page
- One-click workflow: Right-click, drag, describe, submit. No extra tabs or tools
- Multiple projects: Switch between projects directly in the report form
- Page URL captured automatically for easy reproduction
- Self-hosted: All data goes directly to your own DWA Builder instance via HTTPS
- Zero tracking: No analytics, no telemetry, no third-party services

**Setup**

1. Install the extension
2. Click the extension icon and select "Configure DWA Builder URL"
3. Enter your DWA Builder instance URL (e.g., https://builder.yourteam.com)
4. Optionally add an API key for authenticated endpoints
5. Start reporting bugs

**Privacy**

This is an internal tool for teams using DWA Builder. Screenshots and bug reports are sent exclusively to your self-hosted instance. No data is transmitted to any third party. The extension stores only your server URL and optional API key. See our privacy policy for full details.

**Permissions**

- contextMenus: Adds "Report Bug" to the right-click menu
- activeTab: Captures a screenshot of the current tab when you trigger a report
- storage: Saves your settings and temporarily holds pending reports

**Support**

For issues or questions, contact the DWA development team.
